<?php

/**
 * Class that operate on table 'employeeattendance'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-10-10 09:44
 */
class EmployeeattendanceMySqlDAO implements EmployeeattendanceDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return EmployeeattendanceMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM employeeattendance WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM employeeattendance';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM employeeattendance ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param employeeattendance primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM employeeattendance WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param EmployeeattendanceMySql employeeattendance
     */
    public function insert($employeeattendance) {
        $sql = 'INSERT INTO employeeattendance (empid, theImage, sysdate, userid, fingerid, rfid, accessType, syncToServer) VALUES (?, ?, ?, ?, ? , ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeeattendance->empid);
        $sqlQuery->set($employeeattendance->theImage);
        $sqlQuery->set($employeeattendance->sysdate);
        $sqlQuery->setNumber($employeeattendance->userid);
        $sqlQuery->set($employeeattendance->fingerid);
        $sqlQuery->set($employeeattendance->rfid);
        $sqlQuery->setNumber((int) $employeeattendance->accessType);
        $sqlQuery->setNumber((int) $employeeattendance->syncToServer);

        $id = $this->executeInsert($sqlQuery);
        $employeeattendance->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param EmployeeattendanceMySql employeeattendance
     */
    public function update($employeeattendance) {
        $sql = 'UPDATE employeeattendance SET empid = ?, theImage = ?, sysdate = ?, userid = ?, fingerid = ?, rfid = ?, accessType = ?, syncToServer = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($employeeattendance->empid);
        $sqlQuery->set($employeeattendance->theImage);
        $sqlQuery->set($employeeattendance->sysdate);
        $sqlQuery->setNumber($employeeattendance->userid);
        $sqlQuery->set($employeeattendance->fingerid);
        $sqlQuery->set($employeeattendance->rfid);
        $sqlQuery->setNumber((int) $employeeattendance->accessType);
        $sqlQuery->setNumber((int) $employeeattendance->syncToServer);

        $sqlQuery->setNumber($employeeattendance->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM employeeattendance';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByEmpid($value) {
        $sql = 'SELECT * FROM employeeattendance WHERE empid = ? ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTheImage($value) {
        $sql = 'SELECT * FROM employeeattendance WHERE theImage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySysdate($value) {
        $sql = 'SELECT * FROM employeeattendance WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value) {
        $sql = 'SELECT * FROM employeeattendance WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByEmpid($value) {
        $sql = 'DELETE FROM employeeattendance WHERE empid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTheImage($value) {
        $sql = 'DELETE FROM employeeattendance WHERE theImage = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySysdate($value) {
        $sql = 'DELETE FROM employeeattendance WHERE sysdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value) {
        $sql = 'DELETE FROM employeeattendance WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return EmployeeattendanceMySql
     */
    protected function readRow($row) {
        $employeeattendance = new Employeeattendance();

        $employeeattendance->id = $row['id'];
        $employeeattendance->empid = $row['empid'];
        $employeeattendance->theImage = $row['theImage'];
        $employeeattendance->sysdate = $row['sysdate'];
        $employeeattendance->userid = $row['userid'];
        $employeeattendance->fingerid = $row['fingerid'];
        $employeeattendance->rfid = $row['rfid'];
        $employeeattendance->accessType = $row['accessType'];
        $employeeattendance->syncToServer = $row['syncToServer'];
        //
        $employeeattendance->employeeName = $row['employeeName'];

        return $employeeattendance;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return EmployeeattendanceMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>